\version "2.16.0"

\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 2))
  left-margin = 1.3\cm
  line-width = 19.6\cm
  print-page-number = false
  top-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Cât de mărit"
  subtitle = "Коль славен"
  %subsubtitle = "(variantă)"
  composer =  \markup \center-column { "Dimitri Stepanovici Bortnianski (1751 - 1825)"
  	  	\small "Armonizare: Ioan Cartu (1820 - 1875)" }
  tagline = ""
  meter = "Andante"
}

global = {
  \key f \major
  \time 3/4
  \autoBeamOff
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Cât de mă -- rit es -- te Dom -- nul în Si -- on, 
  nu poa -- te lim -- ba a tâl -- cu -- i. 
  Ma -- re es -- te Dom -- nul în Cer pe Tron
  şi pâ -- nă -- ntr-un fir de iar -- bă pe pă -- mânt.
  
  Ma -- re eşti, pre -- tu -- tin -- de -- nea, Doa -- mne,
  pre -- tu -- tin -- de -- nea eşti mă -- rit,
  în zi, in noa -- pte, cu stră -- lu -- ci -- re.
  Ma -- re re.
}

sopMusic = \relative c'' {
  \partial 4
  	c4^\p
  a2 bes4 c2 f8 f g4 f e8 e f2\breathe
  c4^\< d4\!( f) d4
  c2 a4 c bes^\> a g2\!\breathe
  c8 c a2 bes4 c2 f8 f g4^>( f) e f2
  c4^\< d\! f d c2 a4
  d4. c8^\> bes a g2\!\breathe
  c8^\< c e2\!( c4)
  f2^\< c4 a'4\! g f
  f2^\> e4\!\breathe
  f( e) d c2 a8 a
  d4.( c8) bes([ a]) g2\breathe
  c4 e2^\< c4 f2 c4\! a'4 g f 
  e2.^\> f2.\!^\pp\fermata
  \bar"|."
}

altMusic = \relative c'' {
  \partial 4
  	a4
  f2 g4 a2 a8 a bes4 a g8 g a2
  a4 bes( d) bes
  a2 f4 a g f e2
  a8 a f2 g4 a2 a8 a bes4( a) g a2
  a4 bes d bes a2 f4
  bes4. a8 g f e2
  c'8 c bes2( c4)
  a2 a4 c bes a a2 g4
  a( g) bes a2 f8 f
  bes4.( a8) g([ f]) e2
  c'4 bes2 c4 a2 a4 c bes a
  g2( bes4) a2.
}  	

bassMusic = \relative c {
  \clef bass
  \partial 4
	f4
  f2 f4 f2 f8 f e4 f c8 c f2
  f4 bes,2 d4
  f2 f4 g e f c2
  f8 f f2 f4 f2 f8 f c2 c4 f2
  f4 bes, bes d f2 f4
  bes,4. bes8 bes bes c2
  c8 c c2. f2 f4 c c c c2 c4
  c2 bes8([ d]) f2 f8 f 
  bes,2 bes4 c2
  c4 c2 c4 f2 f4 c c c
  c2. <f f,>2.
  
}

myScore = \new Score <<
  \new ChoirStaff <<
     \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \new Voice { \voiceTwo \global \altMusic }
      \addlyrics { \womenWords }
     >>

     \new Staff <<
      \clef bass
      \new Voice { \global \bassMusic }
     >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \context { \Score tempoWholesPerMinute = #(ly:make-moment 60 4) }
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

 \score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}

